<?php
/*
Element Description: Portfolio Box
*/
     // Element Mapping
    function vc_Portfolio_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
        
        $category_dropdown = array( __( 'All Categories', 'brickx') => '0' );	
        $args = array(
                    'taxonomy' => array('portfolio-category'),//ur taxonomy
                    'hide_empty' => false,                  
            );

		$terms_= new WP_Term_Query( $args );
		foreach ( (array)$terms_->terms as $term ) {
			$category_dropdown[$term->name] = $term->slug;		
		}

        // Map the block with vc_map()
        vc_map( 
            array(
                'name' => __('Portfolio', 'rsconstruction'),
                'base' => 'vc_Portfolio',
                'description' => __('Portfolio Box Information', 'rsconstruction'), 
                'category' => __('by RS Theme', 'rsconstruction'),   
                'icon' => get_template_directory_uri().'/framework/assets/img/vc-icon.png',           
                'params' => array(   

                	array(
						"type" => "dropdown",
						"heading" => __("Select Portfolio Style", "rsconstruction"),
						"param_name" => "style",
						"value" => array(						    						
							'Grid' => "Grid", 
							'Slider' => "Slider", 																				
						),
						
					),

                         
                     array(
						"type" => "dropdown",
						"heading" => __("Show title", "rsconstruction"),
						"param_name" => "title",
						"value" => array(							    						
							'Yes' => "Yes", 
							'No' => "No",
						),						
					),
                    array(
					"type" => "dropdown_multi",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Categories", 'brickx'),
					"param_name" => "cat",
					'value' => $category_dropdown,
					), 

					array(
						"type" => "dropdown",
						"heading" => __("Show Filter", "rsconstruction"),
						"param_name" => "show_filter",
						"value" => array(	
						    						
							'Yes' => "Yes", 
							'No' => "No",																																								
						),
						
					),

					array(
						"type" => "dropdown",
						"heading" => __("Filter Alignment", "rsconstruction"),
						"param_name" => "filter_align",
						"value" => array(
                            'Center' => "Center",		
							'Left' 	 => "Left", 
							'Right'	 => "Right", 
																					
						),
						"dependency" => Array('element' => 'show_filter', 'value' => array('Yes')),						
					),

					array(
						'type' => 'textfield',
						'holder' => 'h3',						
						'heading' => __( 'Filter Default Title', 'brickx'),
						'param_name' => 'filter_title',
						'value' => __( '', 'brickx'),
						'description' => __( 'You can add here filter default title (ex: All Projects)' ),
						'admin_label' => false,
						'weight' => 0,
						'value' => 'All Projects',
						"dependency" => Array('element' => 'show_filter', 'value' => array('Yes')),
					   
					),  
					

					           				
             				
					array(
						"type" => "dropdown",
						"heading" => __("Show tagline", "rsconstruction"),
						"param_name" => "tagline",
						"value" => array(	
						    						
							'Yes' => "Yes", 
							'No' => "No", 																																						
						),
						
					),

					
					
					array(
						'type' => 'textfield',
						'holder' => 'h3',						
						'heading' => __( 'Project Per Page', 'brickx'),
						'param_name' => 'per_page',
						'value' => __( '', 'brickx'),
						'description' => __( 'How many project want to show per page', 'brickx'),
						'admin_label' => false,
						'weight' => 0,
						'value' => '9'
					   
					),  
					
					array(
						"type" => "dropdown",
						"heading" => __("How many Column ", "rsconstruction"),
						"param_name" => "column",
						"value" => array(							    						
							
							'Two' => "Two",
							'Four' => "Four", 
							'Three' => "Three",
							'Full' => "Full",
						),
						
					),
					
												 
					array(
						'type' => 'iconpicker',
						'heading' => __( 'Portfolio Icon', 'brickx'),
						'param_name' => 'icon_fontawesome',
						'value' => 'fa fa-search', // default value to backend editor admin_label
						'settings' => array(
							'emptyIcon' => false,
							// default true, display an "EMPTY" icon?
							'iconsPerPage' => 4000,
							// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
						),
					
						'description' => __( 'Select icon from library.', 'brickx'),
					),					
				  
					array(
						'type' => 'colorpicker',
						'heading' => __( 'Icon color', 'brickx'),
						'param_name' => 'color',
						"value" => '#ffffff', //Default color
						"description" => __( "Choose color", "rsconstruction" ),
						'admin_label' => false,
                        'weight' => 0,
                        'group' => 'Style',
					),		
							
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __( "Title color", "rsconstruction" ),
						"param_name" => "titlecolor",
						"value" => '#ffffff', //Default color
						"description" => __( "Choose color", "rsconstruction" ),
						'admin_label' => false,
                        'weight' => 0,
                        'group' => 'Style',
					 ),					  
							 
					
					array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Tag line color", "rsconstruction" ),
					"param_name" => "linecolor",
					"value" => '#ffffff', //Default  color
					"description" => __( "Choose color", "rsconstruction" ),
					'admin_label' => false,
					'weight' => 0,
					'group' => 'Style',
				 ),	
				  array(
						'type' => 'textfield',
						'heading' => __( 'Extra class name', 'js_composer' ),
						'param_name' => 'el_class',
						'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'brickx'),
					),
					
					array(
					'type' => 'css_editor',
					'heading' => __( 'CSS box', 'brickx'),
					'param_name' => 'css',
					'group' => __( 'Design Options', 'brickx'),
				),            
                        
                ),				
					
            )
        );                                
        
    }
     add_action( 'vc_before_init', 'vc_Portfolio_mapping' );
     
    // Element HTML
     function vc_Portfolio_html( $atts,$content ) {
         $attributes = array();
        // Params extraction
        extract(
            shortcode_atts(
                array(
					'title'            => '',
					'tagline'          => '',					
					'titlecolor'       => '',
					'column'           =>'',
					'per_page'         => '9',
					'el_class'         => '',
					'icon_fontawesome' => 'fa fa-search',
					'color'            => '',
					'css'              => '' ,
					'cat'              => '',
					'filter_align'     => 'Center',
					'show_filter'      => '',
					'style'			   => 'Grid',	
					'filter_title'     =>  'All Projects'
                ), 
                $atts,'vc_Portfolio'
           )
        );
	
        $a = shortcode_atts(array(
            'screenshots' => 'screenshots',
        ), $atts);

        $img = wp_get_attachment_image_src($a["screenshots"], "large");

        $imgSrc = $img[0];
		
		//extract content
		$atts['content'] = $content;
		//extact icon 		
		//extract css edit box
		$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );
		
		 //custom class added
		$wrapper_classes = array($el_class) ;			
		$class_to_filter = implode( ' ', array_filter( $wrapper_classes ) );		
		$css_class_custom = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $atts );	
		$col_grid='';
		$col_group='';
		$col_full='';
		$col_filter='';
		$col_grid=$column;
		if($col_grid =='Two'){
			$col_group = 6;
		}
		if($col_grid =='Three'){
			$col_group = 4;
		}
		
		if($col_grid == 'Four'){
			$col_group = 3;
		}
		
		if($col_grid == 'Full'){
			$col_group=3;
			$col_full='full-grid';		
			$col_filter='col-filter';		
		}

		
		$portfolio_style = ( $style == 'Grid' ) ? 'Grid' : 'Slider';
	
        //******************//
        // query post
        //******************//
		$all_project = $filter_title;
		if($portfolio_style == 'Grid'){
        $html ='<div class="rs-portfolio '.$css_class_custom.' '.$col_filter.' '.$portfolio_style.'">
		<div class="portfolio-content '.$css_class.'">';
        // Get taxonomy form portfolio
         if($show_filter !='No'):
	        $html .= '<div class="portfolio-filter filter-'.strtolower($filter_align).'">
		                <button class="active" data-filter="*">'.$all_project.'</button>'; 
		                $taxonomy = "portfolio-category";
	                    $arr= explode(',', $cat);

						for ($i=0; $i < count($arr) ; $i++) { 
		               	 $cats = get_term_by('slug', $arr[$i], $taxonomy);

		               	 if(is_object($cats)):
		               	 	$slug= '.filter_'.$cats->slug;

		               	 	$html .= '<button data-filter="'.$slug.'">'.$cats->name.'</button>';	
		               	 endif;
		               }			

	                
	        $html .=' </div>'; 
	    endif;
		
        $html .='<div class="row"> <div class="grid">'; 
                $arr_cats=array();
                $arr= explode(',', $cat);
					for ($i=0; $i < count($arr) ; $i++) { 
	               	//$cats = get_term_by('slug', $arr[$i], $taxonomy);
	               	// if(is_object($cats)):
	               	$arr_cats[]= $arr[$i];
	               	//endif;
	            }
	           
	           	         
	            if(empty($cat)){
	           	 	$best_wp = new wp_Query(array(
						'post_type' => 'portfolios',
						'posts_per_page' =>$per_page,						
					));		           	
	            }
	            else{ 	           
				   $best_wp = new wp_Query(array(
						'post_type' => 'portfolios',
						'posts_per_page' =>$per_page,
						'tax_query' => array(
					        array(
					            'taxonomy' => 'portfolio-category',
					            'field' => 'slug', //can be set to ID
					            'terms' => $arr_cats//if field is ID you can reference by cat/term number
					        ),
					    )
					));	
				}

       			if( $best_wp->have_posts() ): while( $best_wp->have_posts() ) : $best_wp->the_post();
				$termsArray = get_the_terms( $best_wp->ID, "portfolio-category" );  //Get the terms for this particular item
				 $termsString = ""; //initialize the string that will contain the terms
				foreach ( $termsArray as $term ) { // for each term

					$termsString .= 'filter_'.$term->slug.' '; //create a string that has all the slugs 

				}

				
			   $post_title = get_the_title($best_wp->ID);			  
			    if($title!='No'){
			   		 $post_title_show = get_the_title($best_wp->ID);
				}	
				else{
					 $post_title_show = '';
				}	
				$post_title_show_hover = get_the_title($best_wp->ID);		
			    $post_img_url = get_the_post_thumbnail_url($best_wp->ID,'full');
			    $post_url=get_post_permalink($best_wp->ID); 			    
				if($tagline!='No'){
			   		 $post_tagline = get_post_meta( get_the_ID(), 'tagline', true );
				}
				else{
					 $post_tagline='';
				}
				$cats_show = get_the_term_list( $best_wp->ID, $taxonomy, ' ', ', ');
				

				$html .='
				
				<div class="col-md-'.$col_group.' '.$col_full.' col-xs-6 grid-item mb-30 '.$termsString.'">
                            <div class="portfolio-item">
                                <div class="portfolio-img">
                                   <img src="'.$post_img_url.'" alt="'.$post_title.'" />';
                                   if($post_title_show !== '' || $post_tagline !== ''){	
                                   $html .='<div class="title-block">
                                   		<h3 class="p-title"><a href="'.$post_url.'">'.$post_title_show.'</a></h3>
                                   		<p class="p-desc">'.$post_tagline.'</p>
                                   </div>';
                              		}
                                $html .='</div>
                                <div class="portfolio-content">
                                    <div class="display-table">
                                        <div class="display-table-cell">
                                            <a class="image-popup p-zoom" href="'.$post_img_url.'">
                                                <span class="vc_icon_element-icon '.$icon_fontawesome.'"></span>
                                            </a>
                                            <h3 class="p-title"><a href="'.$post_url.'">'.$post_title_show_hover.'</a></h3>										
                                            <p class="p-category">'.$cats_show.'</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>';
					
						endwhile; 
				wp_reset_query();
			endif;
			
		$html .= "</div></div>
		</div>
		</div>";		
	  return $html; 
	}
    }

add_shortcode( 'vc_Portfolio', 'vc_Portfolio_html' );  